<?php

namespace App\Http\Controllers;

use App\Models\Backlink;
use Illuminate\Http\Request;

class BacklinkController extends Controller
{
    public function index()
    {
        $backlinks = Backlink::all();
        return view('backlinks.index', compact('backlinks'));
    }

    public function create()
    {
        return view('backlinks.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'backlinks' => 'required|array',
            'backlinks.*.label' => 'required|string',
            'backlinks.*.href' => 'required|url',
            'domains' => 'required|string',
        ]);

        Backlink::create($validated);
        return redirect()->route('backlinks.index')->with('success', 'Backlink added successfully.');
    }

    public function edit(Backlink $backlink)
    {
        return view('backlinks.edit', compact('backlink'));
    }

    public function update(Request $request, Backlink $backlink)
    {
        $validated = $request->validate([
            'title' => 'sometimes|required|string|max:255',
            'backlinks' => 'sometimes|required|array',
            'backlinks.*.label' => 'sometimes|required|string',
            'backlinks.*.href' => 'sometimes|required|url',
            'domains' => 'sometimes|required|string',
        ]);

        $backlink->update($validated);
        return redirect()->route('backlinks.index')->with('success', 'Backlink updated successfully.');
    }

    public function destroy(Backlink $backlink)
    {
        $backlink->delete();
        return redirect()->route('backlinks.index')->with('success', 'Backlink deleted successfully.');
    }
    public function getBacklinksByDomain($domain)
    {
        // Fetch backlinks where the domain exists in the domains field
        $backlinks = Backlink::where('domains', 'LIKE', "%$domain%")->get();

        // If no backlinks found, return an empty array
        if ($backlinks->isEmpty()) {
            return response()->json([]);
        }

        // Extract backlinks data
        $formattedBacklinks = [];

        foreach ($backlinks as $backlink) {
            // Ensure backlinks is an array
            $links = is_array($backlink->backlinks) ? $backlink->backlinks : json_decode($backlink->backlinks, true);

            if (is_array($links)) {
                $formattedBacklinks = array_merge($formattedBacklinks, $links);
            }
        }

        return response()->json($formattedBacklinks);
    }
}
