<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('role:2'); // Middleware to restrict access
    }

    public function index()
    {
        // Get all users except those with role 2
        $users = User::where('role', '!=', 2)->get();
        return view('users.index', compact('users'));
    }

    public function editPassword(User $user)
    {
        return view('users.edit-password', compact('user'));
    }

    public function updatePassword(Request $request, User $user)
    {
        $validated = $request->validate([
            'password' => 'required|string|confirmed|min:8',
        ]);

        $user->password = Hash::make($validated['password']);
        $user->save();

        return redirect()->route('users.index')->with('success', 'Password updated successfully.');
    }

    public function destroy(User $user)
    {
        // Prevent deletion of the currently logged-in user
        if ($user->id === Auth::id()) {
            return redirect()->route('users.index')->with('error', 'You cannot delete your own account.');
        }

        $user->delete();
        return redirect()->route('users.index')->with('success', 'User deleted successfully.');
    }
}
