<?php

// app/Http/Middleware/AddUserRoleToView.php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\View;

class AddUserRoleToView
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // Add user role to all views
        if (auth()->check()) {
            View::share('currentUserRole', auth()->user()->role);
        }

        return $next($request);
    }
}
