@extends('layouts.app')

@section('content')
<div class="container mx-auto p-6">
    <h1 class="text-2xl font-bold mb-4">Add Backlink</h1>

    <form action="{{ route('backlinks.store') }}" method="POST" class="bg-white p-6 rounded shadow-md">
        @csrf

        <label class="block mb-2">Title</label>
        <input type="text" name="title" class="w-full border rounded px-3 py-2 mb-4">

        <label class="block mb-2">Backlinks (Label & URL)</label>
        <div id="backlinks">
            <div class="flex gap-2 mb-2">
                <input type="text" name="backlinks[0][label]" placeholder="Label" class="border px-3 py-2 rounded w-1/2">
                <input type="url" name="backlinks[0][href]" placeholder="URL" class="border px-3 py-2 rounded w-1/2">
            </div>
        </div>
        <button type="button" id="addBacklink" class="bg-green-500 text-white px-3 py-1 rounded mb-4">+ Add More</button>

        <label class="block mb-2">Domains (Comma Separated)</label>
        <input type="text" name="domains" class="w-full border rounded px-3 py-2 mb-4">

        <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded">Save</button>
        <a href="{{ route('backlinks.index') }}" class="text-gray-500 ml-4">Cancel</a>
    </form>
</div>

<script>
    let count = 1;
    document.getElementById('addBacklink').addEventListener('click', function() {
        let container = document.getElementById('backlinks');
        let html = `<div class="flex gap-2 mb-2">
                        <input type="text" name="backlinks[${count}][label]" placeholder="Label" class="border px-3 py-2 rounded w-1/2">
                        <input type="url" name="backlinks[${count}][href]" placeholder="URL" class="border px-3 py-2 rounded w-1/2">
                    </div>`;
        container.insertAdjacentHTML('beforeend', html);
        count++;
    });
</script>
@endsection
