@extends('layouts.app')

@section('content')
<div class="container mx-auto p-6">
    <h1 class="text-2xl font-bold mb-4">Manage Backlinks</h1>

    <!-- Add New Backlink Button -->
    <a href="{{ route('backlinks.create') }}" class="bg-blue-500 text-white px-4 py-2 rounded">Add Backlink</a>

    <!-- Backlink List -->
    <div class="mt-6">
        <table class="w-full border-collapse border border-gray-300">
            <thead>
                <tr class="bg-gray-200">
                    <th class="border px-4 py-2">Title</th>
                 
                    <th class="border px-4 py-2">Domains</th>
                    <th class="border px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($backlinks as $backlink)
                <tr class="border">
                    <td class="border px-4 py-2">{{ $backlink->title }}</td>
                    
                    <td class="border px-4 py-2">{{ $backlink->domains }}</td>
                    <td class="border px-4 py-2">
                        <a href="{{ route('backlinks.edit', $backlink->id) }}" class="text-yellow-500 mr-2">Edit</a>
                        
                        <!-- Delete Button with Confirmation -->
                        <form action="{{ route('backlinks.destroy', $backlink->id) }}" method="POST" class="inline delete-form">
                            @csrf
                            @method('DELETE')
                            <button type="button" class="text-red-500 delete-btn" data-id="{{ $backlink->id }}">Delete</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<!-- JavaScript for Delete Confirmation -->
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const deleteButtons = document.querySelectorAll(".delete-btn");

        deleteButtons.forEach(button => {
            button.addEventListener("click", function() {
                let backlinkId = this.dataset.id;
                if (confirm("Are you sure you want to delete this backlink? This action cannot be undone!")) {
                    this.closest("form").submit();
                }
            });
        });
    });
</script>

@endsection
