@extends('layouts.app')

@section('content')
<div class="container mx-auto p-6">
    <!-- SEO-friendly title for the page -->
    <title>Create Hidden Backlink </title>

    <!-- Meta description for SEO -->
    <meta name="description" content="Create a new hidden backlink to improve SEO and website visibility on Your Website Name." />

    <!-- Main content section with a relevant heading -->
    <section>
        <h1 class="text-3xl font-bold text-gray-800 mb-6">Create Hidden Backlink</h1>

        <!-- Add hidden backlink form -->
        <h2 class="text-2xl font-semibold text-gray-700 mb-4">Add a Hidden Backlink</h2>

        <form action="{{ route('hidden_backlinks.store') }}" method="POST" class="space-y-4">
            @csrf
            @include('hidden_backlinks.form', ['hiddenBacklink' => null])

            <!-- Action buttons with accessible text -->
            <div class="flex justify-between mt-6">
                <button type="submit" class="px-6 py-2 bg-green-500 text-white font-semibold rounded-md hover:bg-green-600 focus:outline-none focus:ring-2 focus:ring-green-500">
                    Save Hidden Backlink
                </button>
                <a href="{{ route('hidden_backlinks.index') }}" class="px-6 py-2 bg-gray-500 text-white font-semibold rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500">
                    Back to Hidden Backlinks List
                </a>
            </div>
        </form>
    </section>
</div>
@endsection
