@extends('layouts.app')

@section('title', $slide ?? null ? 'Edit Slide' : 'Create Slide')

@section('content')
<div class="container mx-auto p-6">
    <h1 class="text-3xl font-bold text-gray-900 mb-6">{{ $slide ?? null ? 'Edit Slide' : 'Create Slide' }}</h1>

    <form action="{{ $slide ?? null ? route('slides.update', $slide) : route('slides.store') }}" method="POST" class="bg-white p-8 rounded-lg shadow-lg">
        @csrf
        @if($slide ?? null)
            @method('PUT')
        @endif

        <div class="mb-6">
            <label class="block text-gray-700 font-medium mb-2">Group Name</label>
            <input type="text" name="group_name" value="{{ $slide->group_name ?? old('group_name') }}" placeholder="Enter group name" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300">
            @error('group_name')<p class="text-red-500 mt-1">{{ $message }}</p>@enderror
        </div>

        <div class="mb-6">
            <label class="block text-gray-700 font-medium mb-2">Heading</label>
            <input type="text" name="heading" value="{{ $slide->heading ?? old('heading') }}" placeholder="Enter heading" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300">
            @error('heading')<p class="text-red-500 mt-1">{{ $message }}</p>@enderror
        </div>

        <div id="list-items" class="mb-6">
            @foreach ($slide->listItems ?? [] as $index => $item)
                <div class="mb-4 list-item bg-gray-50 p-6 rounded-lg shadow-sm border border-gray-200">
                    <label class="block text-gray-700 font-medium">List Name</label>
                    <input type="text" name="list_items[{{ $index }}][list_name]" value="{{ $item->list_name }}" placeholder="Enter list name" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300">
                    
                    <label class="block text-gray-700 font-medium mt-4">Domains</label>
                    <input type="text" name="list_items[{{ $index }}][domains]" value="{{ $item->domains }}" placeholder="Enter domains separated by commas" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300">
                    
                    <div class="flex space-x-4 mt-4">
                        <button type="button" class="remove-item bg-red-500 text-white py-2 px-4 rounded-lg flex items-center justify-center shadow-sm hover:bg-red-600 transition duration-300">
                            <i class="fas fa-trash mr-2"></i> Remove
                        </button>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="mb-6">
            <button type="button" id="add-item" class="bg-purple-600 hover:bg-purple-700 text-white py-3 px-6 rounded-lg flex items-center justify-center shadow-md transition duration-300 w-full">
                <i class="fas fa-plus mr-2"></i> Add List Item
            </button>
        </div>

        <div class="flex space-x-4">
            <button type="submit" class="bg-green-500 hover:bg-green-600 text-white py-3 px-6 rounded-lg flex items-center justify-center shadow-md transition duration-300 w-full">
                <i class="fas fa-save mr-2"></i> Save
            </button>
            <a href="{{ route('slides.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white py-3 px-6 rounded-lg flex items-center justify-center shadow-md transition duration-300 w-full">
                <i class="fas fa-times mr-2"></i> Cancel
            </a>
        </div>
    </form>
</div>

<script>
    let index = {{ $slide->listItems->count() ?? 0 }};
    
    document.getElementById('add-item').addEventListener('click', function () {
        const listItemContainer = document.createElement('div');
        listItemContainer.classList.add('mb-4', 'list-item', 'bg-gray-50', 'p-6', 'rounded-lg', 'shadow-sm', 'border', 'border-gray-200');
        listItemContainer.innerHTML = `
            <label class="block text-gray-700 font-medium">List Name</label>
            <input type="text" name="list_items[${index}][list_name]" placeholder="Enter list name" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300">
            <label class="block text-gray-700 font-medium mt-4">Domains</label>
            <input type="text" name="list_items[${index}][domains]" placeholder="Enter domains separated by commas" class="border border-gray-300 rounded-lg w-full py-3 px-4 focus:outline-none focus:border-purple-500 focus:ring-2 focus:ring-purple-200 transition duration-300">
            <div class="flex space-x-4 mt-4">
                <button type="button" class="remove-item bg-red-500 text-white py-2 px-4 rounded-lg flex items-center justify-center shadow-sm hover:bg-red-600 transition duration-300">
                    <i class="fas fa-trash mr-2"></i> Remove
                </button>
                
            </div>
        `;
        document.getElementById('list-items').appendChild(listItemContainer);
        index++;
    });

    document.getElementById('list-items').addEventListener('click', function (event) {
        if (event.target.classList.contains('remove-item') || event.target.closest('.remove-item')) {
            event.target.closest('.list-item').remove();
        }
    });
</script>
@endsection
