@extends('layouts.app')

@section('content')
<div class="p-6 bg-gray-50 min-h-screen">
    <h1 class="text-3xl font-bold text-gray-900 mb-6">Editor</h1>

    <!-- Success and Error Messages -->
    @if(session('success'))
        <div class="bg-green-100 text-green-800 p-4 mb-4 rounded-lg shadow-md flex items-center">
            <i class="fas fa-check-circle mr-2"></i> {{ session('success') }}
        </div>
    @endif
    @if(session('error'))
        <div class="bg-red-100 text-red-800 p-4 mb-4 rounded-lg shadow-md flex items-center">
            <i class="fas fa-exclamation-circle mr-2"></i> {{ session('error') }}
        </div>
    @endif

    <div class="overflow-x-auto">
        <table class="min-w-full bg-white border border-gray-200 rounded-lg shadow-md">
            <thead class="bg-purple-600 text-white">
                <tr>
                    <th class="py-3 px-4 border-b">Name</th>
                    <th class="py-3 px-4 border-b">Email</th>
                    <th class="py-3 px-4 border-b">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($users as $user)
                    <tr class="hover:bg-gray-50 transition duration-200">
                        <td class="py-3 px-4 border-b text-gray-800">{{ $user->name }}</td>
                        <td class="py-3 px-4 border-b text-gray-600">{{ $user->email }}</td>
                        <td class="py-3 px-4 border-b space-x-2 flex">
                            <!-- Change Password Button -->
                            <button onclick="openModal('{{ $user->id }}')"
                                    class="bg-purple-500 text-white px-4 py-2 rounded-lg hover:bg-purple-600 focus:outline-none focus:ring-2 focus:ring-purple-500 transition duration-200 flex items-center">
                                <i class="fas fa-key mr-2"></i> Change Password
                            </button>

                            <!-- Delete Button -->
                            <button onclick="confirmDelete('{{ $user->id }}')"
                                    class="bg-red-500 text-white px-4 py-2 rounded-lg hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-red-500 transition duration-200 flex items-center">
                                <i class="fas fa-trash-alt mr-2"></i> Delete
                            </button>

                            <form action="{{ route('users.destroy', $user->id) }}" method="POST" id="delete-form-{{ $user->id }}" style="display:none;">
                                @csrf
                                @method('DELETE')
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Change password modal -->
    <div id="change-password-modal" class="fixed inset-0 bg-gray-500 bg-opacity-75 flex items-center justify-center hidden">
        <div class="bg-white p-6 rounded-lg shadow-lg w-full max-w-sm">
            <h2 class="text-xl font-semibold mb-4 text-gray-900">Change Password</h2>
            <form id="change-password-form" method="POST">
                @csrf
                @method('PUT')
                <input type="hidden" name="user_id" id="user-id">
                <div class="mb-4">
                    <label for="password" class="block text-gray-700">New Password</label>
                    <input type="password" name="password" id="password" required class="w-full mt-1 border border-gray-300 rounded-md p-2">
                </div>
                <div class="mb-4">
                    <label for="password_confirmation" class="block text-gray-700">Confirm Password</label>
                    <input type="password" name="password_confirmation" id="password_confirmation" required class="w-full mt-1 border border-gray-300 rounded-md p-2">
                </div>
                <div class="flex justify-end space-x-2">
                    <button type="submit" class="bg-purple-500 text-white px-4 py-2 rounded-lg hover:bg-purple-600 focus:outline-none focus:ring-2 focus:ring-purple-500 transition duration-200 flex items-center">
                        <i class="fas fa-check mr-2"></i> Update Password
                    </button>
                    <button type="button" onclick="closeModal()"
                            class="bg-gray-300 text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-400 focus:outline-none focus:ring-2 focus:ring-gray-300 transition duration-200 flex items-center">
                        <i class="fas fa-times mr-2"></i> Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Delete confirmation modal -->
    <div id="delete-confirmation-modal" class="fixed inset-0 bg-gray-500 bg-opacity-75 flex items-center justify-center hidden">
        <div class="bg-white p-6 rounded-lg shadow-lg w-full max-w-sm">
            <h2 class="text-xl font-semibold mb-4 text-gray-900">Confirm Deletion</h2>
            <p class="mb-4 text-gray-700">Are you sure you want to delete this user?</p>
            <div class="flex justify-end space-x-2">
                <button id="confirm-delete-button" type="button" class="bg-red-500 text-white px-4 py-2 rounded-lg hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-red-500 transition duration-200 flex items-center">
                    <i class="fas fa-check mr-2"></i> Delete
                </button>
                <button type="button" onclick="closeDeleteModal()"
                        class="bg-gray-300 text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-400 focus:outline-none focus:ring-2 focus:ring-gray-300 transition duration-200 flex items-center">
                    <i class="fas fa-times mr-2"></i> Cancel
                </button>
            </div>
        </div>
    </div>

    <script>
        let deleteUserId = null;

        function openModal(userId) {
            document.getElementById('change-password-modal').classList.remove('hidden');
            document.getElementById('user-id').value = userId;
            document.getElementById('change-password-form').action = `/users/${userId}/update-password`;
        }

        function closeModal() {
            document.getElementById('change-password-modal').classList.add('hidden');
        }

        function confirmDelete(userId) {
            deleteUserId = userId;
            document.getElementById('delete-confirmation-modal').classList.remove('hidden');
        }

        function closeDeleteModal() {
            document.getElementById('delete-confirmation-modal').classList.add('hidden');
            deleteUserId = null;
        }

        document.getElementById('confirm-delete-button')?.addEventListener('click', function() {
            if (deleteUserId) {
                document.getElementById('delete-form-' + deleteUserId).submit();
            }
            closeDeleteModal();
        });
    </script>
</div>
@endsection
