<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SlideController;
use App\Http\Controllers\BacklinkController;
use App\Http\Controllers\FooterBacklinkController;
use App\Http\Controllers\HiddenBacklinkController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::get('slides', [SlideController::class, 'fetchSlides']);



Route::get('/backlinks/{domain}', [BacklinkController::class, 'getBacklinksByDomain']);
Route::get('/footer-backlink', [FooterBacklinkController::class, 'getAnchorsByDomain']);
Route::get('/hidden-backlink', [HiddenBacklinkController::class, 'getAnchorsByDomain']);