<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use Spatie\Activitylog\Models\Activity;
use App\Http\Controllers\UserController;
use App\Http\Controllers\SlideController;
use App\Http\Controllers\BackupController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\BacklinkController;
use App\Http\Controllers\FooterBacklinkController;
use App\Http\Controllers\HiddenBacklinkController;
use Illuminate\Support\Facades\Redis;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('/redis-test', function () {
    try {
        $pong = Redis::ping();
        return 'Redis connection: ' . $pong;
    } catch (\Exception $e) {
        return 'Redis connection failed: ' . $e->getMessage();
    }
});
Route::get('/clear', function() {

   Artisan::call('cache:clear');
   Artisan::call('config:clear');
   Artisan::call('config:cache');
   Artisan::call('view:clear');

   return "Cleared!";

});
Route::middleware(['auth', 'role:2'])->group(function () {
    Route::get('slides/trash', [SlideController::class, 'trash'])->name('slides.trash');
    Route::post('slides/restore/{id}', [SlideController::class, 'restore'])->name('slides.restore');
   Route::delete('slides/forceDelete/{slide}', [SlideController::class, 'forceDelete'])->name('slides.forceDelete');

});

Route::get('/backup/download', [BackupController::class, 'downloadBackup'])->name('backup.download')->middleware(['auth', 'verified']);

Route::get('/slides/history', function () {
    $activities = Activity::where('subject_type', 'App\Models\Slide')->latest()->get();
    return view('slides.history', compact('activities'));
})->middleware(['auth', 'role:2', 'verified'])->name('slides.history');
Route::get('/', function () {
    return view('welcome');
});
Route::resource('slides', SlideController::class)->middleware(['auth', 'verified']);


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});
Route::post('/list-items/move', [SlideController::class, 'move'])->name('list-items.move')->middleware(['auth', 'verified']);



Route::middleware(['auth'])->group(function () {
    Route::resource('users', UserController::class)->except(['create', 'store', 'show']);
    Route::get('users/{user}/edit-password', [UserController::class, 'editPassword'])->name('users.edit-password');
    Route::put('users/{user}/update-password', [UserController::class, 'updatePassword'])->name('users.update-password');
});

Route::get('/dashboard', function () {
    return redirect()->route('slides.index');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware(['auth'])->group(function () {
   Route::get('/backlinks', [BacklinkController::class, 'index'])->name('backlinks.index');
Route::get('/backlinks/create', [BacklinkController::class, 'create'])->name('backlinks.create');
Route::post('/backlinks', [BacklinkController::class, 'store'])->name('backlinks.store');
Route::get('/backlinks/{backlink}/edit', [BacklinkController::class, 'edit'])->name('backlinks.edit');
Route::put('/backlinks/{backlink}', [BacklinkController::class, 'update'])->name('backlinks.update');
Route::delete('/backlinks/{backlink}', [BacklinkController::class, 'destroy'])->name('backlinks.destroy');
});


// Footer Backlinks
Route::resource('footer_backlinks', FooterBacklinkController::class);
Route::resource('hidden_backlinks', HiddenBacklinkController::class);

require __DIR__.'/auth.php';
