

<?php $__env->startSection('content'); ?>
<div class="container mx-auto p-6">
    <h1 class="text-2xl font-bold mb-4">Edit Backlink</h1>

    <form action="<?php echo e(route('backlinks.update', $backlink->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <!-- Title -->
        <div class="mb-4">
            <label class="block font-bold">Title:</label>
            <input type="text" name="title" value="<?php echo e($backlink->title); ?>" class="w-full border p-2 rounded">
        </div>

        <!-- Backlinks -->
        <div class="mb-4">
            <label class="block font-bold">Backlinks:</label>
            <div id="backlink-container">
                <?php $__currentLoopData = $backlink->backlinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="backlink-item flex items-center gap-2 mb-2">
                    <input type="text" name="backlinks[<?php echo e($index); ?>][label]" value="<?php echo e($link['label']); ?>" placeholder="Label" class="border p-2 rounded">
                    <input type="text" name="backlinks[<?php echo e($index); ?>][href]" value="<?php echo e($link['href']); ?>" placeholder="URL" class="border p-2 rounded w-full">
                    <button type="button" class="bg-red-500 text-white px-3 py-1 rounded remove-backlink">Remove</button>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Add New Backlink Button -->
            <button type="button" id="add-backlink" class="mt-2 bg-green-500 text-white px-3 py-1 rounded">Add Backlink</button>
        </div>

        <!-- Domains -->
        <div class="mb-4">
            <label class="block font-bold">Domains:</label>
            <input type="text" name="domains" value="<?php echo e($backlink->domains); ?>" class="w-full border p-2 rounded">
        </div>

        <!-- Submit Button -->
        <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded">Update Backlink</button>
    </form>
</div>

<!-- JavaScript for Adding & Removing Backlinks -->
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const backlinkContainer = document.getElementById("backlink-container");
        const addBacklinkBtn = document.getElementById("add-backlink");

        // Remove backlink field
        backlinkContainer.addEventListener("click", function(event) {
            if (event.target.classList.contains("remove-backlink")) {
                event.target.closest(".backlink-item").remove();
            }
        });

        // Add new backlink field
        addBacklinkBtn.addEventListener("click", function() {
            const index = backlinkContainer.children.length;
            const newBacklink = `
                <div class="backlink-item flex items-center gap-2 mb-2">
                    <input type="text" name="backlinks[${index}][label]" placeholder="Label" class="border p-2 rounded">
                    <input type="text" name="backlinks[${index}][href]" placeholder="URL" class="border p-2 rounded w-full">
                    <button type="button" class="bg-red-500 text-white px-3 py-1 rounded remove-backlink">Remove</button>
                </div>`;
            backlinkContainer.insertAdjacentHTML("beforeend", newBacklink);
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\shuvo\Downloads\PBN_Panel\resources\views/backlinks/edit.blade.php ENDPATH**/ ?>